/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.YesNoQuestionPromptEvent;

public class BooleanQuestionPromptEvent
extends PromptOutputEvent {
    private static final List<String> LENIENT_YES_NO_CHOICES = Lists.newArrayList((Object[])new String[]{"yes", "no", "y", "n"});
    private final String question;
    private final boolean defaultValue;

    public BooleanQuestionPromptEvent(long timestamp, String question, boolean defaultValue) {
        super(timestamp);
        this.question = question;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getPrompt() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.question);
        builder.append(" (default: ");
        String defaultString = this.defaultValue ? "yes" : "no";
        builder.append(defaultString);
        builder.append(") [");
        builder.append(StringUtils.join(YesNoQuestionPromptEvent.YES_NO_CHOICES, (String)", "));
        builder.append("] ");
        return builder.toString();
    }

    public String getQuestion() {
        return this.question;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public PromptOutputEvent.PromptResult<Boolean> convert(String text) {
        if (text.isEmpty()) {
            return PromptOutputEvent.PromptResult.response(this.defaultValue);
        }
        String trimmed = text.toLowerCase(Locale.US).trim();
        if (LENIENT_YES_NO_CHOICES.contains(trimmed)) {
            return PromptOutputEvent.PromptResult.response(BooleanUtils.toBoolean((String)trimmed));
        }
        String defaultString = this.defaultValue ? "yes" : "no";
        return PromptOutputEvent.PromptResult.newPrompt("Please enter 'yes' or 'no' (default: '" + defaultString + "'): ");
    }
}

